$.extend({
	setGeoLocData: function(options) {
		if (options.latitude) {
			options.latitude.field.val(options.latitude.value.toFixed(5));
		}
		if (options.longitude) {
			options.longitude.field.val(options.longitude.value.toFixed(5));
		}
		if (options.altitude) {
			options.altitude.field.val(options.altitude.value);
		}
	},
	
	urlQuery: function(key, keykey) {
		var dict = {};
		
		// Populate dict
		$.each(location.search.substr(1).split('&'), function(index, item) {
			var parts = item.split('='),
				k = parts[0] && decodeURIComponent(parts[0]), kk,
				v = parts[1] && decodeURIComponent(parts[1]);
			
			if (/.+\[\]$/.test(k)) {
				// Array key
				k = k.substring(0, k.lastIndexOf('['));
				if (dict[k]) {
					dict[k].push(v);
				} else {
					dict[k] = [v];
				}
			} else if (/.+\[.+\]$/.test(k)) {
				// Object key
				kk = k.substring(k.lastIndexOf('[') + 1, k.lastIndexOf(']'));
				k = k.substring(0, k.lastIndexOf('['));
				dict[k] = dict[k] || {};
				dict[k][kk] = v;
			} else {
				dict[k] = v;
			}
		});
		
		if (key && keykey) {
			return dict[key][keykey];
		} else if (key) {
			return dict[key];
		} else {
			return dict;
		}
	},
	
	serializeForm: function($form, $whitelist, $blacklist) {
		var dataArray = $form.serializeArray(),
			data = {}, tmp;
		
		if ($whitelist) {
			$whitelist.each(function(idx, element) {
				data[$(element).attr('name')] = false;
			});
		}
		$.each(dataArray, function(idx, element) {
			data[element.name] = element.value;
			// Integer
			if (/^[0-9]+$/.test(data[element.name])) {
				data[element.name] = parseInt(data[element.name]);
			}
			// Float
			if (/^[0-9]*\.[0-9]+$/.test(data[element.name])) {
				data[element.name] = parseFloat(data[element.name]);
			}
			// Date
			if (/^[0-9]{2}\/[0-9]{2}\/[0-9]{4}$/.test(data[element.name])) {
				data[element.name] = new Date(data[element.name]);
			}
			// Time
			if (/^[0-9]{2}:[0-9]{2}\s*(?:am|pm)$/i.test(data[element.name])) {
				tmp = new Date(null);
				data[element.name] = data[element.name].split(':');
				if (data[element.name][1].toLowerCase().indexOf('pm') >= 0) {
					tmp.setHours(parseInt(data[element.name][0]) + 12,
						parseInt(data[element.name][1].substr(0, 2)));
				} else {
					tmp.setHours(parseInt(data[element.name][0]),
						parseInt(data[element.name][1].substr(0, 2)));
				}
				data[element.name] = tmp;
			}
			// Timespan
			if (/^[0-9]{2}:[0-9]{2}:[0-9]{2}$/.test(data[element.name])) {
				tmp = new Date(null);
				data[element.name] = data[element.name].split(':');
				tmp.setHours(parseInt(data[element.name][0]),
							 parseInt(data[element.name][1]),
							 parseInt(data[element.name][2]))
				data[element.name] = tmp;
			}
		});
		if ($blacklist) {
			$blacklist.each(function(idx, element) {
				delete data[$(element).attr('name')];
			});
		}
		return data;
	},
	
	MutationObserver: function(callback) {
		var mo = window.MutationObserver || window.WebKitMutationObserver;
		
		return new mo(callback || function(mutations, observer) {
			console.log(mutations, observer);
		});
	}
});

$(function() {
	$('[data-toggle=tooltip]').tooltip();
	$('[data-provide=datepicker]').datetimepicker({
		format: 'MM/dd/yyyy',
		pickTime: false
	}).on('changeDate', function(e) {
		$(this).find('input').valid();
	});
	$('[data-provide=timepicker]').datetimepicker({
		format: 'HH:mm PP',
		pickDate: false,
		pick12HourFormat: true,
		pickSeconds: false
	});
	$('[data-provide=timespanpicker]').datetimepicker({
		format: 'hh:mm:ss',
		pickDate: false
	});

	$('i.icon-chevron-up').addClass('glyphicon glyphicon-chevron-up')
		.removeClass('icon-chevron-up')
		.parent().addClass('btn-default');
	$('i.icon-chevron-down').addClass('glyphicon glyphicon-chevron-down')
		.removeClass('icon-chevron-down')
		.parent().addClass('btn-default');
		
	/*$.MutationObserver().observe(document, {
		subtree: true,
		childList: true
	});*/
});
